<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Astrotomic\Translatable\Translatable;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;

class Carta extends Model
{
    use Translatable, SoftDeletes;

    protected $fillable = ['orden', 'activo'];

    public $translatedAttributes = ['nombre', 'descripcion', 'slug'];
    public $translationModel = CartaLang::class;
    public $translationTable = 'carta_langs';

    // Configuración de slugs
    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('nombre')
            ->saveSlugsTo('slug');
    }

    public function scopeActivo($query)
    {
        return $query->where('activo', true);
    }

    public function scopeOrdenado($query)
    {
        return $query->orderBy('orden', 'asc');
    }

       public function bebidas()
    {
        return $this->hasMany(Bebida::class);
    }
      public function subCartas()
    {
        return $this->hasMany(SubCarta::class);
    }



    public function platos()
    {
        return $this->hasMany(Plato::class);
    }
}
