<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;

class PlatoLang extends Model
{
    use HasSlug;

    protected $table = 'plato_langs';
    public $timestamps = false;
    protected $fillable = ['plato_id', 'locale', 'nombre', 'descripcion', 'slug'];

    public function plato()
    {
        return $this->belongsTo(Plato::class);
    }

    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('nombre')
            ->saveSlugsTo('slug');
    }
}
