<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
         Schema::create('sub_carta_langs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sub_carta_id')->constrained('sub_cartas')->cascadeOnDelete();
            $table->string('locale')->index();
            $table->string('nombre');
            $table->string('slug')->unique();
            $table->text('descripcion')->nullable();

            $table->unique(['sub_carta_id', 'locale']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sub_carta_langs');
    }
};
