<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAlergenosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('alergenos', function (Blueprint $table) {
            $table->id();
            $table->integer('orden')->default(0)->comment('Orden de visualización');
            $table->boolean('activo')->default(true)->comment('Estado activo/inactivo');
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('alergeno_langs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('alergeno_id')->constrained('alergenos')->cascadeOnDelete();
            $table->string('locale')->index();
            $table->string('nombre');
            $table->text('descripcion')->nullable();
            $table->unique(['alergeno_id', 'locale']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('alergeno_langs');
        Schema::dropIfExists('alergenos');
    }
}