<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bebida_precios', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bebida_id')->constrained('bebidas')->cascadeOnDelete();
            $table->string('tipo_presentacion'); // copa, vaso, botella, chupito
            $table->decimal('precio', 10, 2);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bebida_precios');
    }
};
