@extends('adminlte::page')

@section('title', 'Usuarios' . ' | ' . config('app.name'))

@section('content_header')
    <div class="w-100">
        @php
            $breadcrumbs = [
                ['name' => 'Inicio', 'route' => 'dashboard', 'icon' => 'fa-home'],
                ['name' => 'Cartas', 'route' => 'cartas.index'],
                ['name' => 'Lista de Cartas'],
            ];
        @endphp

        <nav aria-label="breadcrumb">
            <ol class="breadcrumb bg-light p-2 rounded shadow-sm">
                @foreach ($breadcrumbs as $breadcrumb)
                    @if (isset($breadcrumb['route']))
                        <li class="breadcrumb-item">
                            <a href="{{ route($breadcrumb['route']) }}">
                                @if (isset($breadcrumb['icon']))
                                    <i class="fas {{ $breadcrumb['icon'] }} mr-1"></i>
                                @endif
                                {{ $breadcrumb['name'] }}
                            </a>
                        </li>
                    @else
                        <li class="breadcrumb-item active" aria-current="page">{{ $breadcrumb['name'] }}</li>
                    @endif
                @endforeach
            </ol>
        </nav>
    </div>
@stop

@section('content')

    <div class="m-0">
        <div class="card shadow-sm">
            <div class="card-header">
                <div class="row align-items-center">
                    <!-- Título -->
                    <div class="col-12 col-md-6">
                        <h5 class="mb-md-0">Gestión de Cartas</h5>
                    </div>

                    <!-- Botón -->
                    <div class="col-12 col-md-6 text-md-right">
                        <button class="btn btn-success btn-sm" id="createNewCarta">
                            <i class="fas fa-plus"></i> Nueva Carta
                        </button>
                    </div>
                </div>
            </div>

            <div class="card-body p-2">
                <table class="table table-bordered table-hover" id="cartas-table" style="width: 100%;">
                    <thead class="thead-light">
                        <tr>
                            <th style="width: 5%"></th>
                            <th style="width: 5%">ID</th>
                            <th style="width: 45%">Nombre (ES)</th>
                            <th style="width: 15%">Orden</th>
                            <th style="width: 15%">Activo</th>
                            <th style="width: 10%">Acciones</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>


    <!-- Modal -->
    <!-- Modal -->
    <div class="modal fade" id="cartaModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form id="cartaForm">
                @csrf
                <div class="modal-content">
                    <div class="modal-header bg-secondary">
                        <h5 class="modal-title">Carta</h5>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="id" id="id">

                        @php
                            $langs = \App\Models\Lang::whereNull('deleted_at')->get(); // solo idiomas activos
                        @endphp

                        <!-- Nombre -->
                        <div class="form-group">
                            <label>Nombre</label>
                            @foreach ($langs as $lang)
                                <div class="input-group mb-2">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <img src="{{ asset($lang->image ?? 'images/empty.png') }}"
                                                alt="{{ $lang->name }}" width="20" height="20" class="me-1">
                                        </span>

                                    </div>
                                    <input type="text" name="nombre[{{ $lang->code }}]" class="form-control"
                                        placeholder="Nombre en {{ $lang->name }}" required>
                                </div>
                            @endforeach
                        </div>

                        <!-- Descripción -->
                        <div class="form-group">
                            <label>Descripción</label>
                            @foreach ($langs as $lang)
                                <div class="input-group mb-2">
                                    <span class="input-group-text">
                                        <img src="{{ asset($lang->image ?? 'images/empty.png') }}" alt="{{ $lang->name }}"
                                            width="20" height="20" class="me-1 rounded">
                                    </span>
                                    <input type="text" name="descripcion[{{ $lang->code }}]" class="form-control"
                                        placeholder="Descripción en {{ $lang->name }}">
                                </div>
                            @endforeach
                        </div>


                        <div class="form-group">
                            <label>Orden</label>
                            <input type="number" name="orden" id="orden" class="form-control">
                        </div>

                        <div class="form-group">
                            <label>Activo</label>
                            <input type="checkbox" name="activo" id="activo" value="1" checked>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Guardar</button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                    </div>
                </div>
            </form>
        </div>
    </div>




@stop

@section('css')
    {{-- Add here extra stylesheets --}}
    {{-- <link rel="stylesheet" href="/css/admin_custom.css"> --}}
@stop

@push('js')
    <script>
        $(function() {
            var table = $('#cartas-table').DataTable({
                responsive: {
                    details: {
                        type: 'column', // el signo + en la primera columna
                        target: 0 // en qué columna colocar el signo +
                    }
                },
                columnDefs: [{
                    className: 'dtr-control', // clase obligatoria para el botón de expandir
                    orderable: false,
                    targets: 0
                }],
                processing: true,
                serverSide: true,
                ajax: "{{ route('cartas.data') }}",
                columns: [{
                        data: null,
                        defaultContent: ''
                    },{
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'nombre',
                        name: 'nombre'
                    },
                    {
                        data: 'orden',
                        name: 'orden'
                    },
                    {
                        data: 'activo',
                        name: 'activo',
                        render: function(d) {
                            return d ? 'Sí' : 'No';
                        }
                    },
                    {
                        data: 'acciones',
                        name: 'acciones',
                        orderable: false,
                        searchable: false
                    }
                ],
                 order: [
                    [1, 'desc']
                ], // <-- orden descendente por la columna "orden"
            });

            $('#createNewCarta').click(function() {
                $('#cartaForm').trigger("reset");
                $('#id').val('');
                $('#cartaModal').modal('show');
            });

            $('body').on('click', '.edit', function() {
                var id = $(this).data('id');

                // Generar la ruta con Blade y reemplazar el ID
                var url = "{{ route('cartas.edit', ':id') }}";
                url = url.replace(':id', id);

                $.get(url, function(data) {
                    $('#id').val(data.id);
                    $('#orden').val(data.orden);
                    $('#activo').prop('checked', data.activo);

                    // Español
                    $('#nombre_es').val(data.nombre['es-ES'] ?? '');
                    $('#descripcion_es').val(data.descripcion['es-ES'] ?? '');

                    // Inglés
                    $('#nombre_en').val(data.nombre['en'] ?? '');
                    $('#descripcion_en').val(data.descripcion['en'] ?? '');

                    $('#cartaModal').modal('show');
                });
            });



            $('#cartaForm').submit(function(e) {
                e.preventDefault();

                let form = $(this);

                $.ajax({
                    data: form.serialize(),
                    url: "{{ route('cartas.store') }}",
                    type: "POST",
                    success: function(response) {
                        $('#cartaModal').modal('hide');
                        table.ajax.reload();

                      

                        Toast.fire({
                            icon: 'success',
                            title: 'Carta guardada correctamente'
                        });
                    },
                    error: function(xhr) {

                        // mensaje por defecto
                        let message = "Ocurrió un error al guardar la carta.";

                        // si Laravel devuelve errores de validación
                        if (xhr.responseJSON && xhr.responseJSON.errors) {
                            let errors = xhr.responseJSON.errors;
                            message = Object.values(errors).join('<br>');
                        }

                        Toast.fire({
                            icon: 'error',
                            title: message
                        });
                    }
                });
            });


            $('body').on('click', '.delete', function() {
                var id = $(this).data('id');

                Swal.fire({
                    title: '¿Estás seguro?',
                    text: "¡Esta acción eliminará la carta!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: 'Sí, eliminar',
                    cancelButtonText: 'Cancelar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            type: "DELETE",
                            url: "{{ url('admin/cartas') }}/" + id,
                            data: {
                                _token: '{{ csrf_token() }}'
                            },
                            success: function(response) {
                                table.ajax.reload();

                                Toast.fire({
                                    icon: 'success',
                                    title: 'Carta eliminada correctamente'
                                });
                            },
                            error: function(xhr) {
                               

                                Toast.fire({
                                    icon: 'error',
                                    title: 'No se pudo eliminar la carta'
                                });
                            }
                        });
                    }
                });
            });

        });
    </script>
@endpush
