<?php $__env->startSection('title', 'Alergenos' . ' | ' . config('app.name')); ?>

<?php $__env->startSection('content_header'); ?>
    <div class="w-100">

        <?php
            $breadcrumbs = [
                ['name' => 'Inicio', 'route' => 'dashboard', 'icon' => 'fa-home'],
                ['name' => 'Alergenos', 'route' => 'alergenos.index'],
                ['name' => 'Lista de Alergenos'],
            ];
        ?>

        <nav aria-label="breadcrumb">
            <ol class="breadcrumb bg-light p-2 rounded shadow-sm">
                <?php $__currentLoopData = $breadcrumbs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $breadcrumb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(isset($breadcrumb['route'])): ?>
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route($breadcrumb['route'])); ?>">
                                <?php if(isset($breadcrumb['icon'])): ?>
                                    <i class="fas <?php echo e($breadcrumb['icon']); ?> mr-1"></i>
                                <?php endif; ?>
                                <?php echo e($breadcrumb['name']); ?>

                            </a>
                        </li>
                    <?php else: ?>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e($breadcrumb['name']); ?></li>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ol>
        </nav>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="m-0">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row align-items-center">
                            <!-- Título -->
                            <div class="col-12 col-md-6">
                                <h5 class="mb-md-0">Gestión de Alérgenos</h5>
                            </div>

                            <!-- Botón -->
                            <div class="col-12 col-md-6 text-md-right">
                                <button type="button" class="btn btn-success btn-sm mb-3" data-toggle="modal"
                                    data-target="#alergenoModal">
                                    <i class="fas fa-plus"></i> Nuevo Alérgeno
                                </button>
                            </div>
                        </div>

                    </div>
                    <div class="card-body p-2">


                        <div class="table-responsive">
                            <table id="alergenos-table" class="table table-bordered table-striped" style="width: 100%;">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>ID</th>
                                        <th>Nombre</th>
                                        <th>Orden</th>
                                        <th>Estado</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal para agregar/editar -->
    <div class="modal fade" id="alergenoModal" tabindex="-1" role="dialog" aria-labelledby="alergenoModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header bg-secondary text-white">
                    <h5 class="modal-title" id="alergenoModalLabel">Nuevo Alérgeno</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="alergenoForm">
                    <input type="hidden" id="alergeno_id" name="alergeno_id" value="">

                    <div class="modal-body">

                        
                        <h5>Nombre</h5>
                        <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="form-group mb-3">
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <img src="<?php echo e(asset($lang->image ?? 'images/empty.png')); ?>" alt="<?php echo e($lang->name); ?>"
                                            width="20" height="20">
                                    </span>
                                    <input type="text" class="form-control" id="nombre_<?php echo e($lang->code); ?>"
                                        name="nombre[<?php echo e($lang->code); ?>]" placeholder="Nombre en <?php echo e($lang->name); ?>"
                                        required>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        
                        <h5>Descripción</h5>
                        <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="form-group mb-3">
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <img src="<?php echo e(asset($lang->image ?? 'images/empty.png')); ?>"
                                            alt="<?php echo e($lang->name); ?>" width="20" height="20">
                                    </span>
                                    <input type="text" class="form-control" id="descripcion_<?php echo e($lang->code); ?>"
                                        name="descripcion[<?php echo e($lang->code); ?>]"
                                        placeholder="Descripción en <?php echo e($lang->name); ?>" required>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="orden">Orden</label>
                                    <input type="number" class="form-control" id="orden" name="orden" value=""
                                        required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="activo" class="d-block">Estado</label>
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="activo" name="activo"
                                            value="1" checked>
                                        <label class="custom-control-label" for="activo">Activo</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Guardar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        // Configurar CSRF token para todas las solicitudes AJAX
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $(document).ready(function() {
            // DataTable
            var table = $('#alergenos-table').DataTable({
                responsive: {
                    details: {
                        type: 'column', // el signo + en la primera columna
                        target: 0 // en qué columna colocar el signo +
                    }
                },
                columnDefs: [{
                    className: 'dtr-control', // clase obligatoria para el botón de expandir
                    orderable: false,
                    targets: 0
                }],
                processing: true,
                serverSide: true,
                ajax: {
                    url: "<?php echo e(route('alergenos.datatables')); ?>",
                    type: 'GET'
                },
                columns: [{
                        data: null,
                        defaultContent: ''
                    }, {
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'nombre',
                        name: 'nombre',
                        orderable: true,
                        searchable: true
                    },
                    {
                        data: 'orden',
                        name: 'orden'
                    },
                    {
                        data: 'activo',
                        name: 'activo',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'acciones',
                        name: 'acciones',
                        orderable: false,
                        searchable: false
                    }
                ],
                order: [
                    [1, 'desc']
                ], // <-- orden descendente por la columna "orden"
            });

            // Función para limpiar completamente el modal
            function resetModal() {
                $('#alergenoForm')[0].reset();
                $('#alergeno_id').val('');
                $('#orden').val('');
                $('#activo').prop('checked', true);

                // Limpiar todos los campos de traducción
                $('input[name^="nombre["]').val('');
                $('textarea[name^="descripcion["]').val('');
            }

            // Abrir modal para crear
            $('#alergenoModal').on('show.bs.modal', function(e) {
                $('#alergenoModalLabel').text('Nuevo Alérgeno');
                resetModal();
            });

            // Abrir modal para editar - SOLUCIÓN DEFINITIVA
            $(document).on('click', '.btn-editar', function() {
                var id = $(this).data('id');
                var button = $(this);

                // Mostrar loading
                button.html('<i class="fas fa-spinner fa-spin"></i>');
                button.prop('disabled', true);

                $.ajax({
                    url: "<?php echo e(url('admin/alergenos')); ?>/" + id,
                    type: 'GET',
                    success: function(response) {
                        console.log('Datos recibidos para editar:', response);

                        // PRIMERO: Abrir el modal
                        $('#alergenoModal').modal('show');

                        // SEGUNDO: Una vez que el modal está visible, llenar los campos
                        setTimeout(function() {
                                // Establecer valores básicos
                                $('#alergenoModalLabel').text('Editar Alérgeno');
                                $('#alergeno_id').val(response.id);
                                $('#orden').val(response.orden);
                                $('#activo').prop('checked', response.activo);

                                // Llenar traducciones - MÉTODO MEJORADO
                                if (response.translations && response.translations.length >
                                    0) {
                                    response.translations.forEach(function(translation) {
                                        console.log('Estableciendo:', translation
                                            .locale, translation.nombre);

                                        // USAR MÚLTIPLES MÉTODOS PARA ASEGURAR QUE FUNCIONE

                                        // Método 1: Por ID (debería funcionar)
                                        $('#nombre_' + translation.locale).val(
                                            translation.nombre || '');
                                        $('#descripcion_' + translation.locale).val(
                                            translation.descripcion || '');

                                        // Método 2: Por nombre (backup)
                                        $('input[name="nombre[' + translation
                                            .locale + ']"]').val(translation
                                            .nombre || '');
                                        $('textarea[name="descripcion[' +
                                            translation.locale + ']"]').val(
                                            translation.descripcion || '');

                                        // Método 3: Forzar el cambio de valor (último recurso)
                                        setTimeout(function() {
                                            $('#nombre_' + translation
                                                .locale).val(translation
                                                .nombre || '').trigger(
                                                'change');
                                            $('#descripcion_' + translation
                                                    .locale).val(translation
                                                    .descripcion || '')
                                                .trigger('change');
                                        }, 100);
                                    });
                                } else {
                                    console.warn('No se encontraron traducciones');
                                }

                                // DEBUG: Verificar que los valores se establecieron
                                setTimeout(function() {
                                    console.log('=== VERIFICACIÓN DE VALORES ===');
                                    $('input[name^="nombre["], textarea[name^="descripcion["]')
                                        .each(function() {
                                            console.log($(this).attr('name') +
                                                ': "' + $(this).val() + '"');
                                        });
                                }, 200);

                            },
                            300
                        ); // Pequeño delay para asegurar que el modal esté completamente renderizado
                    },
                    error: function(xhr) {
                        console.error('Error:', xhr);
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Error al cargar los datos: ' + (xhr.responseJSON
                                ?.message || 'Error desconocido')
                        });
                    },
                    complete: function() {
                        button.html('<i class="fas fa-edit"></i>');
                        button.prop('disabled', false);
                    }
                });
            });

            $('#alergenoForm').on('submit', function(e) {
                e.preventDefault();

                // Validaciones
                var ordenValue = $('#orden').val();
                if (!ordenValue || ordenValue.trim() === '' || isNaN(ordenValue)) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'El campo orden es requerido'
                    });
                    return;
                }

                let hasName = false;
                $('input[name^="nombre["]').each(function() {
                    if ($(this).val().trim() !== '') {
                        hasName = true;
                        return false;
                    }
                });
                if (!hasName) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Debe ingresar al menos un nombre'
                    });
                    return;
                }

                // Determinar método
                var id = $('#alergeno_id').val();
                var isEdit = id !== '';

                // SIEMPRE USAR POST - Laravel manejará el método via _method
                var url = "<?php echo e(route('alergenos.store')); ?>"; // Siempre apuntar a store
                if (isEdit) {
                    url = "<?php echo e(url('admin/alergenos')); ?>/" + id; // Para edición, pero el método será POST
                }

                // Crear FormData
                var formData = new FormData(this);

                // AGREGAR ESTO: Campo _method para Laravel
                if (isEdit) {
                    formData.append('_method', 'PUT');
                }

                // SOLUCIÓN: Asegurar que el campo 'activo' siempre esté presente
                if ($('#activo').is(':checked')) {
                    formData.set('activo', '1');
                } else {
                    formData.set('activo', '0'); // Valor cuando no está checked
                }
                // DEBUG
                console.log('=== DATOS ENVIADOS ===');
                for (let pair of formData.entries()) {
                    console.log(pair[0] + ': ' + pair[1]);
                }

                // Mostrar loading
                var submitButton = $(this).find('button[type="submit"]');
                var originalText = submitButton.html();
                submitButton.html('<i class="fas fa-spinner fa-spin"></i> ' + (isEdit ? 'Actualizando...' :
                    'Creando...'));
                submitButton.prop('disabled', true);

                $.ajax({
                    url: url,
                    type: 'POST', // SIEMPRE POST
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        if (response.success) {
                            $('#alergenoModal').modal('hide');
                            table.ajax.reload();
                            Swal.fire({
                                icon: 'success',
                                title: 'Éxito',
                                text: response.message,
                                timer: 2000
                            });
                        }
                    },
                    error: function(xhr) {
                        // Manejo de errores...
                    },
                    complete: function() {
                        submitButton.html(originalText);
                        submitButton.prop('disabled', false);
                    }
                });
            });

            // Eliminar alérgeno
            $(document).on('click', '.btn-eliminar', function() {
                var id = $(this).data('id');
                var button = $(this);

                Swal.fire({
                    title: '¿Está seguro?',
                    text: "¡No podrá revertir esta acción!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Sí, eliminar!',
                    cancelButtonText: 'Cancelar',
                    reverseButtons: true
                }).then((result) => {
                    if (result.isConfirmed) {
                        button.html('<i class="fas fa-spinner fa-spin"></i>');
                        button.prop('disabled', true);

                        $.ajax({
                            url: "<?php echo e(url('admin/alergenos')); ?>/" + id,
                            type: 'DELETE',
                            success: function(response) {
                                if (response.success) {
                                    table.ajax.reload();

                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Eliminado',
                                        text: response.message,
                                        timer: 2000,
                                        showConfirmButton: false
                                    });
                                }
                            },
                            error: function(xhr) {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error',
                                    text: xhr.responseJSON?.message ||
                                        'Error al eliminar'
                                });
                            },
                            complete: function() {
                                button.html('<i class="fas fa-trash"></i>');
                                button.prop('disabled', false);
                            }
                        });
                    }
                });
            });

            // Limpiar modal cuando se cierra
            $('#alergenoModal').on('hidden.bs.modal', function() {
                resetModal();
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\PAN82\htdocs\manu\resources\views/alergenos/index.blade.php ENDPATH**/ ?>