<?php $__env->startSection('title', 'Ordenar Sub Cartas' . ' | ' . config('app.name')); ?>

<?php $__env->startSection('content_header'); ?>
    <div class="w-100">
        <?php
            $breadcrumbs = [
                ['name' => 'Inicio', 'route' => 'dashboard', 'icon' => 'fa-home'],
                ['name' => 'SubCartas', 'route' => 'subcartas.index'],
                ['name' => 'Ordenar Sub Cartas'],
            ];
        ?>

        <nav aria-label="breadcrumb">
            <ol class="breadcrumb bg-light p-2 rounded shadow-sm">
                <?php $__currentLoopData = $breadcrumbs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $breadcrumb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(isset($breadcrumb['route'])): ?>
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route($breadcrumb['route'])); ?>">
                                <?php if(isset($breadcrumb['icon'])): ?>
                                    <i class="fas <?php echo e($breadcrumb['icon']); ?> mr-1"></i>
                                <?php endif; ?>
                                <?php echo e($breadcrumb['name']); ?>

                            </a>
                        </li>
                    <?php else: ?>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e($breadcrumb['name']); ?></li>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ol>
        </nav>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="m-0">
        <div class="card shadow-sm">
            <div class="card-header">
                <div class="row align-items-center">
                    <!-- Título -->
                    <div class="col-12 col-md-6">
                        <h5 class="mb-md-0">Ordenar Sub Cartas</h5>
                    </div>

                    <!-- Botón -->

                </div>
            </div>

            <div class="card-body p-2">

                <p class="text-muted">Arrastra y suelta para cambiar el orden de las Sub cartas.</p>

                <?php $__currentLoopData = $cartas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $carta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="card mb-4 shadow-sm">
                        <div class="card-header bg-primary text-white d-flex align-items-center">
                            <i class="fa-solid fa-layer-group me-2"></i>
                            <?php echo e($carta->translate(app()->getLocale())->nombre); ?>

                        </div>
                        <ul class="list-group list-group-flush sortable" data-carta-id="<?php echo e($carta->id); ?>">
                            <?php $__currentLoopData = $carta->subCartas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="list-group-item d-flex align-items-center" data-id="<?php echo e($sub->id); ?>">
                                    <i class="fa-solid fa-arrows-alt fa-lg me-3 text-secondary"></i>
                                    <?php echo e($sub->translate(app()->getLocale())->nombre); ?>

                                    <?php if(!$sub->activo): ?>
                                        <span class="badge bg-danger ms-auto"><i class="fa-solid fa-ban"></i>
                                            Inactivo</span>
                                    <?php endif; ?>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <div class="mt-3">
                    <button id="guardarOrden" class="btn btn-success">
                        <i class="fa-solid fa-floppy-disk"></i> Guardar Orden
                    </button>
                </div>

            </div>
        </div>
    </div>





<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<style>
    ul.sortable {
    list-style: none;
    padding-left: 0;
    margin: 0;
}
.sortable li {
    cursor: grab; /* cuando está quieto */
}
.sortable li:active {
    cursor: grabbing; /* cuando lo arrastras */
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
    <script>
        // Activar sortable en cada lista de subcartas
        $(function() {
            $(".sortable").sortable({
                placeholder: "ui-state-highlight"
            }).disableSelection();

            $('#guardarOrden').click(function() {
                let orden = {};

                $(".sortable").each(function() {
                    let cartaId = $(this).data('carta-id');
                    let subOrden = [];
                    $(this).find('li').each(function() {
                        subOrden.push($(this).data('id'));
                    });
                    orden[cartaId] = subOrden;
                });

                $.ajax({
                    url: "<?php echo e(route('subcartas.ordenar.guardar')); ?>",
                    method: "POST",
                    data: {
                        orden: orden,
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    success: function(resp) {
                        if (resp.success) {
                            Toast.fire({
                                icon: 'success',
                                title: 'Orden guardado correctamente'
                            });
                        }
                    },
                    error: function() {
                        Toast.fire({
                            icon: 'error',
                            title: 'Error al guardar el orden'
                        });
                    }
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\PAN82\htdocs\manu\resources\views/subcartas/ordenar.blade.php ENDPATH**/ ?>